/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.lock;

import com.ibm.hsc.common.exceptions.PIHscServerException;
import com.ibm.hsc.lock.GroupLock;
import com.ibm.hsc.lock.Lock;
import com.ibm.hsc.lock.RequestId;
import com.ibm.hsc.lock.RequestItem;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Vector;

public class RequestQueue {
    private String mName;
    private Hashtable mReqHash = new Hashtable();
    private LinkedList mReqList = new LinkedList();
    private static Hashtable mReqQueueHash = new Hashtable();

    private RequestQueue(String string) {
        this.mName = string;
    }

    public String getName() {
        return this.mName;
    }

    public static RequestQueue getRequestQueue(String string) {
        RequestQueue requestQueue = (RequestQueue)mReqQueueHash.get(string);
        if (requestQueue == null) {
            requestQueue = new RequestQueue(string);
            mReqQueueHash.put(string, requestQueue);
        }
        return requestQueue;
    }

    public static RequestQueue getRequestQueue(Lock lock) {
        String string = lock.getTopSectionId();
        return RequestQueue.getRequestQueue(string);
    }

    public static RequestItem getTopRunningRequest(Lock lock) {
        String string = lock.getTopSectionId();
        RequestQueue requestQueue = RequestQueue.getRequestQueue(string);
        ListIterator listIterator = requestQueue.mReqList.listIterator(0);
        while (listIterator.hasNext()) {
            RequestItem requestItem = (RequestItem)listIterator.next();
            int n = requestItem.getStatus();
            Lock lock2 = requestItem.getLock();
            if (n != 2 && n != 3 || lock2 != lock) continue;
            return requestItem;
        }
        return null;
    }

    protected static void switchToGroupLock(Lock lock, GroupLock groupLock) throws PIHscServerException {
        Lock lock2;
        int n;
        Thread thread = Thread.currentThread();
        RequestQueue requestQueue = RequestQueue.getRequestQueue(lock);
        RequestItem requestItem = requestQueue.get(thread, lock);
        int n2 = requestItem.getLockType();
        int n3 = requestItem.getStatus();
        if (n2 != 1) {
            System.out.println("switchToGroupLock: only WRITE lock can be switched to a group lock.");
            throw new PIHscServerException("3201");
        }
        if (n3 != 2) {
            System.out.println("switchToGroupLock: only RUNNING lock can be switched to a group lock.");
            throw new PIHscServerException("3200");
        }
        Vector vector = groupLock.getLockVec();
        for (n = 0; n < vector.size(); ++n) {
            lock2 = (Lock)vector.elementAt(n);
            if (lock2.isDescendant(lock)) continue;
            throw new PIHscServerException("3200");
        }
        System.out.println("before switch: " + String.valueOf(requestQueue));
        requestQueue.remove(thread, lock);
        for (n = 0; n < vector.size(); ++n) {
            lock2 = (Lock)vector.elementAt(n);
            RequestItem requestItem2 = new RequestItem(thread, lock2, n2);
            requestItem2.setStatus(2);
            requestQueue.addFirst(requestItem2);
        }
        System.out.println("after switch: " + String.valueOf(requestQueue));
    }

    public static synchronized void printAllQueues() {
        Enumeration enumeration = mReqQueueHash.elements();
        while (enumeration.hasMoreElements()) {
            RequestQueue requestQueue = (RequestQueue)enumeration.nextElement();
            System.out.println(String.valueOf(requestQueue));
        }
    }

    protected boolean hasBlockingRequest(RequestItem requestItem) {
        Lock lock;
        RequestItem requestItem2;
        boolean bl = false;
        Lock lock2 = requestItem.getLock();
        int n = requestItem.getLockType();
        boolean bl2 = false;
        ListIterator listIterator = this.mReqList.listIterator(0);
        while (!bl && listIterator.hasNext()) {
            requestItem2 = (RequestItem)listIterator.next();
            lock = requestItem2.getLock();
            int n2 = requestItem2.getLockType();
            int n3 = requestItem2.getStatus();
            if (n3 == -1) continue;
            if (requestItem2.equals(requestItem)) break;
            if (lock != lock2 && !lock.isDescendant(lock2) && !lock2.isDescendant(lock)) continue;
            if (n3 == 3) {
                bl2 = true;
                continue;
            }
            if (n3 == 0 || n3 == 2) {
                bl = true;
                continue;
            }
            if (n3 != 1) continue;
            if (n2 == 1 || n2 == 4 || n2 == 3) {
                bl = true;
                continue;
            }
            if (n != 1 && n != 4 && n != 3) continue;
            bl = true;
        }
        while (!bl && listIterator.hasNext()) {
            requestItem2 = (RequestItem)listIterator.next();
            lock = requestItem2.getLock();
            if (requestItem2.getStatus() != 2 || lock != lock2 && !lock.isDescendant(lock2) && !lock2.isDescendant(lock)) continue;
            bl = true;
        }
        return bl;
    }

    protected RequestItem get(Thread thread, Lock lock) {
        RequestId requestId = new RequestId(thread, lock);
        return (RequestItem)this.mReqHash.get(requestId);
    }

    protected void add(RequestItem requestItem) {
        this.mReqList.add(requestItem);
        this.mReqHash.put(requestItem.getRequestId(), requestItem);
    }

    private void addFirst(RequestItem requestItem) {
        this.mReqList.addFirst(requestItem);
        this.mReqHash.put(requestItem.getRequestId(), requestItem);
    }

    protected void remove(Thread thread, Lock lock) {
        RequestId requestId = new RequestId(thread, lock);
        RequestItem requestItem = (RequestItem)this.mReqHash.remove(requestId);
        this.mReqList.remove(requestItem);
    }

    protected void remove(RequestId requestId) {
        RequestItem requestItem = (RequestItem)this.mReqHash.remove(requestId);
        this.mReqList.remove(requestItem);
    }

    protected boolean canRunNow(RequestItem requestItem) {
        Lock lock = requestItem.getLock();
        int n = requestItem.getLockType();
        boolean bl = true;
        ListIterator listIterator = this.mReqList.listIterator(0);
        while (bl && listIterator.hasNext()) {
            RequestItem requestItem2 = (RequestItem)listIterator.next();
            Lock lock2 = requestItem2.getLock();
            if (!lock2.related(lock) || requestItem2.getStatus() == 3 || requestItem2.getStatus() == -1) continue;
            if (n == 1 || n == 4 || n == 3) {
                bl = false;
                continue;
            }
            if (requestItem2.getStatus() == 2 && requestItem2.getLockType() != 1 && requestItem2.getLockType() != 4 && requestItem2.getLockType() != 3) continue;
            bl = false;
        }
        return bl;
    }

    protected void reschedule() {
        if (Lock.debug) {
            System.out.println("start of reschedule " + Thread.currentThread());
        }
        ListIterator listIterator = this.mReqList.listIterator(0);
        while (listIterator.hasNext()) {
            RequestItem requestItem = (RequestItem)listIterator.next();
            if (requestItem.getStatus() != 0 || this.hasBlockingRequest(requestItem)) continue;
            requestItem.setStatus(1);
            if (requestItem.getLockType() == 2 || requestItem.getLockType() == 3) {
                GroupLock groupLock = GroupLock.get(requestItem.getThread());
                if (groupLock == null || groupLock.isRunning()) continue;
                if (Lock.debug) {
                    System.out.println(Thread.currentThread() + " interrupts: " + requestItem.getThread());
                }
                requestItem.getThread().interrupt();
                continue;
            }
            if (Lock.debug) {
                System.out.println(Thread.currentThread() + " interrupts " + requestItem.getThread());
            }
            requestItem.getThread().interrupt();
        }
        if (Lock.debug) {
            System.out.println("end of reschedule " + Thread.currentThread());
        }
    }

    protected Vector killWaitingWriters(Lock lock) {
        Vector<RequestQueue> vector = new Vector<RequestQueue>();
        vector.add(this);
        Vector<RequestId> vector2 = new Vector<RequestId>();
        ListIterator listIterator = this.mReqList.listIterator(0);
        while (listIterator.hasNext()) {
            RequestItem requestItem = (RequestItem)listIterator.next();
            int n = requestItem.getStatus();
            if (!requestItem.getLock().related(lock) || n == -1 || n == 3) continue;
            if (requestItem.getLockType() == 1) {
                requestItem.setStatus(-1);
                System.out.println(Thread.currentThread() + " interrupts " + requestItem.getThread());
                requestItem.getThread().interrupt();
                continue;
            }
            if (requestItem.getLockType() != 3) continue;
            Thread thread = requestItem.getThread();
            GroupLock groupLock = GroupLock.get(thread);
            Vector vector3 = groupLock.getLockVec();
            for (int i = 0; i < vector3.size(); ++i) {
                Lock lock2 = (Lock)vector3.elementAt(i);
                RequestQueue requestQueue = RequestQueue.getRequestQueue(lock2);
                RequestItem requestItem2 = requestQueue.get(thread, lock2);
                requestItem2.setStatus(-1);
                if (requestQueue == this) {
                    vector2.add(requestItem2.getRequestId());
                    continue;
                }
                if (!vector.contains(requestQueue)) {
                    vector.add(requestQueue);
                }
                requestQueue.remove(thread, lock2);
            }
            GroupLock.setLockStatus(thread, -1);
            if (Lock.debug) {
                System.out.println(Thread.currentThread() + " interrupts: " + thread + " for GroupLock failure");
            }
            thread.interrupt();
        }
        for (int i = 0; i < vector2.size(); ++i) {
            this.remove((RequestId)vector2.elementAt(i));
        }
        return vector;
    }

    protected boolean hasPendingRequest(Lock lock) {
        ListIterator listIterator = this.mReqList.listIterator(0);
        while (listIterator.hasNext()) {
            boolean bl;
            RequestItem requestItem = (RequestItem)listIterator.next();
            int n = requestItem.getLockType();
            int n2 = requestItem.getStatus();
            Lock lock2 = requestItem.getLock();
            if (n2 == -1 || !lock2.related(lock)) continue;
            boolean bl2 = bl = n2 == 3;
            if (bl) {
                System.out.println("There is a pending lock: " + requestItem);
            }
            return bl;
        }
        return false;
    }

    protected RequestItem getTopRelatedRequest(RequestItem requestItem) {
        Lock lock = requestItem.getLock();
        int n = requestItem.getLockType();
        ListIterator listIterator = this.mReqList.listIterator(0);
        while (listIterator.hasNext()) {
            RequestItem requestItem2 = (RequestItem)listIterator.next();
            int n2 = requestItem2.getLockType();
            int n3 = requestItem2.getStatus();
            Lock lock2 = requestItem2.getLock();
            if (n3 == 3 || n3 == -1 || !(!(n != 0 && n != 2 || n3 != 2 && n3 != 1 || n2 != 0 && n2 != 2) ? requestItem.equals(requestItem2) : lock2.related(lock))) continue;
            return requestItem2;
        }
        return null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("RequestQueue: ");
        stringBuffer.append(this.mName);
        stringBuffer.append("\n");
        ListIterator listIterator = this.mReqList.listIterator(0);
        while (listIterator.hasNext()) {
            RequestItem requestItem = (RequestItem)listIterator.next();
            stringBuffer.append(requestItem);
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }
}

